const express = require('express');
const router = express.Router();
const settingController = require('../controllers/settingController');
const { authClient } = require('../middleware/auth');

router.get('/', authClient, settingController.index);
router.get('/display', authClient, settingController.display);
router.post('/save', authClient, settingController.save);
router.get('/summary_box', authClient, settingController.summaryBox);
router.get('/excel_pdf', authClient, settingController.excelPdf);
router.post('/excel_pdf', authClient, settingController.excelPdf);

module.exports = router;
