const express = require('express');
const router = express.Router();
const messageController = require('../controllers/messageController');
const { authAdmin } = require('../middleware/auth');

router.get('/list', authAdmin, messageController.list);
router.get('/:id', authAdmin, messageController.getMessage);
router.post('/add', authAdmin, messageController.add);
router.put('/edit/:id', authAdmin, messageController.edit);
router.delete('/del/:id', authAdmin, messageController.del);

module.exports = router;
