const express = require('express');
const router = express.Router();
const auditController = require('../controllers/auditController');
const { authAdmin } = require('../middleware/auth');

router.get('/', authAdmin, auditController.index);
router.get('/clients', authAdmin, auditController.clients);
router.get('/add_new', authAdmin, auditController.add);
router.get('/edit/:id', authAdmin, auditController.edit);
router.post('/add', authAdmin, auditController.addClient);
router.put('/edit_account/:id', authAdmin, auditController.editClient);
router.delete('/del/:id', authAdmin, auditController.del);
router.get('/display', authAdmin, auditController.display);
router.post('/save', authAdmin, auditController.save);
router.post('/createExcel', authAdmin, auditController.createExcel);
router.post('/delSheet', authAdmin, auditController.delSheet);

module.exports = router;
