const { Sequelize } = require('sequelize');
const config = require('../config/database.js');

const env = process.env.NODE_ENV || 'development';
const dbConfig = config[env];

const sequelize = new Sequelize(
  dbConfig.database,
  dbConfig.username,
  dbConfig.password,
  {
    host: dbConfig.host,
    port: dbConfig.port,
    dialect: dbConfig.dialect,
    logging: dbConfig.logging,
    pool: dbConfig.pool
  }
);

const db = {
  sequelize,
  Sequelize,
  User: require('./User')(sequelize, Sequelize.DataTypes),
  Branch: require('./Branch')(sequelize, Sequelize.DataTypes),
  Client: require('./Client')(sequelize, Sequelize.DataTypes),
  Message: require('./Message')(sequelize, Sequelize.DataTypes),
  Import: require('./Import')(sequelize, Sequelize.DataTypes),
  TblSave: require('./TblSave')(sequelize, Sequelize.DataTypes),
  TblSaveAudit: require('./TblSaveAudit')(sequelize, Sequelize.DataTypes),
  TblAuditExcel: require('./TblAuditExcel')(sequelize, Sequelize.DataTypes),
  TblCrcLog: require('./TblCrcLog')(sequelize, Sequelize.DataTypes),
  SettingExcel: require('./SettingExcel')(sequelize, Sequelize.DataTypes)
};

// Associations
db.User.hasMany(db.Branch, { foreignKey: 'user_id' });
db.Branch.belongsTo(db.User, { foreignKey: 'user_id' });

db.User.hasMany(db.Client, { foreignKey: 'user_id' });
db.Client.belongsTo(db.User, { foreignKey: 'user_id' });
db.Client.belongsTo(db.Branch, { foreignKey: 'branch_id' });
db.Branch.hasMany(db.Client, { foreignKey: 'branch_id' });

db.Branch.hasMany(db.Message, { foreignKey: 'branch_id' });
db.Message.belongsTo(db.Branch, { foreignKey: 'branch_id' });
db.User.hasMany(db.Message, { foreignKey: 'user_id' });
db.Message.belongsTo(db.User, { foreignKey: 'user_id' });

db.User.hasMany(db.Import, { foreignKey: 'user_id' });
db.Import.belongsTo(db.User, { foreignKey: 'user_id' });

db.User.hasMany(db.TblSave, { foreignKey: 'user_id' });
db.TblSave.belongsTo(db.User, { foreignKey: 'user_id' });

db.User.hasMany(db.TblSaveAudit, { foreignKey: 'user_id' });
db.TblSaveAudit.belongsTo(db.User, { foreignKey: 'user_id' });

db.User.hasMany(db.TblAuditExcel, { foreignKey: 'user_id' });
db.TblAuditExcel.belongsTo(db.User, { foreignKey: 'user_id' });
db.Client.hasMany(db.TblAuditExcel, { foreignKey: 'client_id' });
db.TblAuditExcel.belongsTo(db.Client, { foreignKey: 'client_id' });

db.Client.hasMany(db.TblCrcLog, { foreignKey: 'client_id' });
db.TblCrcLog.belongsTo(db.Client, { foreignKey: 'client_id' });

db.User.hasMany(db.SettingExcel, { foreignKey: 'user_id' });
db.SettingExcel.belongsTo(db.User, { foreignKey: 'user_id' });

module.exports = db;
