module.exports = (sequelize, DataTypes) => {
  const Message = sequelize.define('Message', {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    branch_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    c1_message: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    c2_message: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    g1_message: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    g2_message: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    }
  }, {
    tableName: 'messages',
    underscored: true,
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
  });
  return Message;
};
