module.exports = (sequelize, DataTypes) => {
  const Client = sequelize.define('Client', {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    ename: {
      type: DataTypes.STRING(255),
      allowNull: false
    },
    epassword: {
      type: DataTypes.STRING(255),
      allowNull: false
    },
    ephone: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    branch_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    refid: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    app: {
      type: DataTypes.STRING(20),
      allowNull: false,
      defaultValue: 'RESTAFF'
    },
    status: {
      type: DataTypes.STRING(20),
      allowNull: false,
      defaultValue: 'offline'
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    }
  }, {
    tableName: 'clients',
    underscored: true,
    timestamps: false
  });
  return Client;
};
