'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('import', {
      id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
      },
      header_name: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      sr_no: {
        type: Sequelize.STRING(50),
        allowNull: true
      },
      acc_no: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      acc_date: {
        type: Sequelize.STRING(50),
        allowNull: true
      },
      code: {
        type: Sequelize.STRING(50),
        allowNull: true
      },
      customer_name: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      customer: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      advance: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      inquiry_office: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      cell_no: {
        type: Sequelize.STRING(50),
        allowNull: true
      },
      item_no: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      price: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      balance: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      installment: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      os: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      paid: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      unpaid: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      last_installment_date: {
        type: Sequelize.STRING(50),
        allowNull: true
      },
      p_installments: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      last_remarks: {
        type: Sequelize.TEXT,
        allowNull: true
      },
      remarks: {
        type: Sequelize.TEXT,
        allowNull: true
      },
      cr_action: {
        type: Sequelize.TEXT,
        allowNull: true
      },
      call_time: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      path: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      refid: {
        type: Sequelize.INTEGER,
        allowNull: true
      },
      user_id: {
        type: Sequelize.INTEGER,
        allowNull: true,
        references: { model: 'users', key: 'id' },
        onUpdate: 'CASCADE',
        onDelete: 'SET NULL'
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP')
      }
    });
    await queryInterface.addIndex('import', ['refid'], { name: 'idx_refid' });
    await queryInterface.addIndex('import', ['refid', 'code'], { name: 'idx_refid_code' });
    await queryInterface.addIndex('import', ['refid', 'remarks'], { name: 'idx_refid_remarks' });
    await queryInterface.addIndex('import', ['user_id'], { name: 'idx_user_id' });
  },

  async down(queryInterface) {
    await queryInterface.dropTable('import');
  }
};
